require("SandboxVars")
table.insert(SandboxVars, {
	options = {
		{ name = "spawnRate", title = "Spawn Rate (%)", default = -1, min = -1, max = 100, step = 1 },
		{ name = "spawnRateModifiedTrafficJams", title = "Spawn Rate (%)", default = -1, min = -1, max = 100, step = 1 },
		{ name = "randomAngle", title = "Use Random Vehicle Angles", default = true },
		{ name = "spawnRateBurnt", title = "Spawn Rate (%) to Modify ALL Vehicles into Burnt Vehicles", default = -1, min = -1, max = 100, step = 1 },
		{ name = "baseVehicleQuality", title = "Base Vehicle Quality", default = -0.1, min = 0.0, max = 1.3, step = 0.1 },
		{ name = "chanceToPartDamage", title = "Chance to Part Damage (%)", default = -1, min = 0, max = 100, step = 1 },
	}
})

local function GamestaSetVehicleZones()
	for zoneName, zoneData in pairs(VehicleZoneDistribution) do
		if type(zoneData) == "table" and zoneData.vehicles then
			if zoneData == VehicleZoneDistribution.modified_trfjm then
				zoneData.spawnRate = 90
				if SandboxVars.GamestaVehicleZones.spawnRateModifiedTrafficJams >= 0 then
					zoneData.spawnRate = SandboxVars.GamestaVehicleZones.spawnRateModifiedTrafficJams
				end
				zoneData.chanceToSpawnBurnt = 30
				zoneData.baseVehicleQuality = 0.4
				zoneData.chanceToPartDamage = 60
				zoneData.chanceToSpawnKey = 90
				zoneData.chanceToSpawnSpecial = 1
				zoneData.chanceToSpawnNormal = 1
			elseif zoneData == VehicleZoneDistribution.junkyard then
				zoneData.spawnRate = 90
				zoneData.chanceToSpawnBurnt = 40
				zoneData.baseVehicleQuality = 0.0
				zoneData.chanceToPartDamage = 60
				zoneData.chanceToSpawnNormal = 0
				zoneData.chanceToSpawnSpecial = 0
			elseif zoneData == VehicleZoneDistribution.trafficjamw then
				zoneData.chanceToSpawnBurnt = 20
				zoneData.chanceToSpawnKey = 80
				zoneData.baseVehicleQuality = 0.4
				zoneData.chanceToPartDamage = 100
				zoneData.chanceToSpawnNormal = 1
				zoneData.chanceToSpawnSpecial = 1
			elseif zoneData == VehicleZoneDistribution.trafficjame then
				zoneData.chanceToSpawnBurnt = 20
				zoneData.chanceToSpawnKey = 80
				zoneData.baseVehicleQuality = 0.4
				zoneData.chanceToPartDamage = 100
				zoneData.chanceToSpawnNormal = 1
				zoneData.chanceToSpawnSpecial = 1
			elseif zoneData == VehicleZoneDistribution.trafficjamn then
				zoneData.chanceToSpawnBurnt = 20
				zoneData.chanceToSpawnKey = 80
				zoneData.baseVehicleQuality = 0.4
				zoneData.chanceToPartDamage = 100
				zoneData.chanceToSpawnNormal = 1
				zoneData.chanceToSpawnSpecial = 1
			elseif zoneData == VehicleZoneDistribution.trafficjams then
				zoneData.chanceToSpawnBurnt = 20
				zoneData.chanceToSpawnKey = 80
				zoneData.baseVehicleQuality = 0.4
				zoneData.chanceToPartDamage = 100
				zoneData.chanceToSpawnNormal = 1
				zoneData.chanceToSpawnSpecial = 1
			elseif SandboxVars.GamestaVehicleZones.spawnRate >= 0 and zoneData ~= (VehicleZoneDistribution.modified_trfjm or VehicleZoneDistribution.junkyard) then
				zoneData.spawnRate = SandboxVars.GamestaVehicleZones.spawnRate
			end
			if SandboxVars.GamestaVehicleZones.spawnRateBurnt >= 0 then
				zoneData.chanceToSpawnBurnt = SandboxVars.GamestaVehicleZones.spawnRateBurnt
			end
			if SandboxVars.GamestaVehicleZones.baseVehicleQuality >= 0 then
				zoneData.baseVehicleQuality = SandboxVars.GamestaVehicleZones.baseVehicleQuality
			end
			if SandboxVars.GamestaVehicleZones.chanceToPartDamage >= 0 then
				zoneData.chanceToPartDamage = SandboxVars.GamestaVehicleZones.chanceToPartDamage
			end
			
			VehicleZoneDistribution.parkingstall.randomAngle = SandboxVars.GamestaVehicleZones.randomAngle
			VehicleZoneDistribution.trailerpark.randomAngle = SandboxVars.GamestaVehicleZones.randomAngle;
			VehicleZoneDistribution.police.randomAngle = SandboxVars.GamestaVehicleZones.randomAngle
			VehicleZoneDistribution.ambulance.randomAngle = SandboxVars.GamestaVehicleZones.randomAngle
			VehicleZoneDistribution.fire.randomAngle = SandboxVars.GamestaVehicleZones.randomAngle
			VehicleZoneDistribution.transit.randomAngle = SandboxVars.GamestaVehicleZones.randomAngle
		end
	end
end
Events.OnLoadedMapZones.Add(GamestaSetVehicleZones)
